/*==========================================================================
* DEMOS.C - Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved*
*                                                                          *
* Demo functions used by PGLDEMO.EXE                                       *
* ======================================================================== */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <bios.h>
#include <malloc.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pgldemo.h"

/*
 *****************************************************************************
 */

/*
 * GLOBAL VARIABLES
 */

int MaxSX, MaxSY, MaxRandX, MaxRandY, ScrollXPos, ScrollYPos;     
char BITMStr1[MAX_BITM_LEN], BITMStr2[MAX_BITM_LEN], BITMStr3[MAX_BITM_LEN];

unsigned long huge *BlitBufPtr;

char *ColourNames[] = 
{
   "",      "Black",
   "Dark",  "Blue",
   "Dark",  "Green",
   "Dark",  "Cyan",
   "Dark",  "Red",
   "Dark",  "Magenta",
   "",      "Brown",
   "Light", "Gray",
   "Dark",  "Gray",
   "Light", "Blue",
   "Light", "Green",
   "Light", "Cyan",
   "Light", "Red",
   "Light", "Magenta",
   "",      "Yellow",
   "",      "White"
};

/*
 * EXTERNAL VARIABLES
 */

extern PGL_modeconfig modeinfo;

extern int MinRX, MaxRX, MinRY, MaxRY;    // define random display area
extern int XCenter, YCenter;    // holds coordinates for the center of the screen

extern int *Patterns, TotalPatterns;
extern unsigned MaxColor;
extern long fillpattern[];
extern PGL_font *smallfont;
extern PGL_font *normalfont;
extern PGL_font *largefont;
extern PGL_font *extrafont;

/*
 *****************************************************************************
 */

int SetPatternFill(void)
   //
   // SetPatternFill -- Sets the fill type to the pre-set patterned fill
   // 
   {
   // set up the fill pattern

   PGL_setfillpattern(8, 14, fillpattern);
   PGL_setfilltype(USERDEFINED_FILL);
   PGL_setbgmix(S_MIX);

   return (0);
   }

/*
 *****************************************************************************
 */

int SetSolidFill(void)
   //
   // SetSolidFill -- Sets the fill type to solid fill
   // 
   {
   // restore fill type to solid fill
   PGL_setfilltype(SOLID_FILL);
   PGL_setbgmix(D_MIX);

   return (0);
   }

/*
 *****************************************************************************
 */

int FullScreen(int BackColour)
   {
   PGL_setfgcolor(PGL_getcolorcode(BackColour));
   PGL_setbgcolor(PGL_getcolorcode(BackColour)); // for pattern demos
   PGL_drawrect(MinRX, MinRY-1, MaxRX - MinRX + 1, MaxRY - MinRY + 2);

   return(0);
   }

/*
 *****************************************************************************
 */

int HalfScreen(int BackColour)
   {
   PGL_setfgcolor(PGL_getcolorcode(BackColour));
   PGL_setbgcolor(PGL_getcolorcode(BackColour)); // for pattern demos
   PGL_drawrect(XCenter+1, MinRY, MaxRX - XCenter, MaxRY - MinRY + 1);

   return(0);
   }

/*
 *****************************************************************************
 */

int InitBlit(void)
   //
   // InitScreenBlit -- must start with a initialized screen of data that
   //                   can then be blitted around.         
   //
   {
   // local variables
   PGL_point shape[5];
   int Colour, XDim, YDim, XStart, YStart, X1, Y1, DisplayLine, TotalLines,
       Character, LineLength;
   unsigned int Color;

   unsigned char CharStr[2] = {1,0};   // string for single character printing

   // determine dimensions of rects in 4 x 4 display of colours
   XStart = MinRX;
   YStart = MinRY;
   if((XCenter-MinRX)%2 == 1)
      {
      // X dimension is odd, make it even
      XStart++;
      }
   if((MaxRY-MinRY)%2 == 1)
      {
      // Y dimension is odd, make it even
      YStart++;
      }
   XDim = (XCenter - XStart) / 4;
   YDim = (MaxRY - YStart) / 4;
   X1 = XStart;
   Y1 = YStart;

   // cycle through all 16 colours
   for(Colour=BLACK;Colour<=WHITE;Colour++)
      {
      // set the color
      PGL_setfgcolor(PGL_getcolorcode(Colour));

      // draw the rectangle
      PGL_drawrect(X1, Y1, XDim+1, YDim+1);

      // border the rectangle with white
      PGL_setfgcolor(PGL_getcolorcode(WHITE));

      // set the coordinates for all 5 points
      shape[0].x = X1;
      shape[0].y = Y1;
      shape[1].x = X1+XDim;
      shape[1].y = shape[0].y;
      shape[2].x = shape[1].x;
      shape[2].y = Y1+YDim;
      shape[3].x = shape[0].x;
      shape[3].y = shape[2].y;
      shape[4].x = shape[0].x;
      shape[4].y = shape[0].y;

      // draw the rectangle
      PGL_drawpolyline(4,shape);

      // point to next rectangle
      if((X1+=XDim) > XDim*4)
         {
         X1 = XStart;
         Y1 += YDim;
         }
      }

   // add some multi coloured text to the squares
   // calculate number of characters displayed per line for this font

   // (leaving a border of 2 characters on either side)
   LineLength = XDim*4 / normalfont->charwidth;

   // calculate number of lines of text
   TotalLines = YDim*4 / normalfont->charheight;

   // calculate starting Y position
   YStart += (YDim*4 - (TotalLines * normalfont->charheight))/2;

   // calculate starting X position for font show off - 256 chars per line
   XStart += (XDim*4 - (LineLength * normalfont->charwidth))/2;

   // loop through display lines, cycling through colors
   for(DisplayLine = 0; DisplayLine < TotalLines; DisplayLine++)
      {
      // loop through LineLength characters per line
      for(Character=0; Character < LineLength; Character++)
         {
         // set the color
         PGL_setfgcolor(PGL_getcolorcode(Color));

         // check if max color reached
         if(++Color > MaxColor)
            Color = 0;

         // print this character
         PGL_text(XStart + (Character * normalfont->charwidth),YStart,
                  CharStr, normalfont);

         // increment next character in set -- will wrap to 0 automatically
         ++CharStr[0];
         }
      // point to next text line
      YStart += normalfont->charheight;
      }

   // return to caller
   return(0);
   }

/*
 *****************************************************************************
 */

int ColourDemo(void)
   {
   // local variables
   PGL_point shape[5];
   int Colour, XDim, YDim, XStart, YStart, X1, Y1;
   int TextX1, TextY1, TextX2, TextY2;
   int wid1, wid2;

   // determine dimensions of rects in 4 x 4 display of colours
   XStart = MinRX;
   YStart = MinRY;
   if((MaxRX-MinRX)%2 == 1)
      {
      // X dimension is odd, make it even
      XStart++;
      }
   if((MaxRY-MinRY)%2 == 1)
      {
      // Y dimension is odd, make it even
      YStart++;
      }
   XDim = (MaxRX - XStart) / 4;
   YDim = (MaxRY - YStart) / 4;
   X1 = XStart;
   Y1 = YStart;

   // cycle through all 16 colours
   for(Colour=BLACK;Colour<=WHITE;Colour++)
      {
      // set the color
      PGL_setfgcolor(PGL_getcolorcode(Colour));

      // draw the rectangle
      PGL_drawrect(X1, Y1, XDim+1, YDim+1);

      // border the rectangle with white
      PGL_setfgcolor(PGL_getcolorcode(WHITE));

      // set the coordinates for all 5 points
      shape[0].x = X1;
      shape[0].y = Y1;
      shape[1].x = X1+XDim;
      shape[1].y = shape[0].y;
      shape[2].x = shape[1].x;
      shape[2].y = Y1+YDim;
      shape[3].x = shape[0].x;
      shape[3].y = shape[2].y;
      shape[4].x = shape[0].x;
      shape[4].y = shape[0].y;

      // draw the rectangle
      PGL_drawpolyline(4,shape);

      // draw BLACK text in WHITE box
      if (Colour == WHITE)
      {
         PGL_setfgcolor(PGL_getcolorcode(BLACK));
      }

      // identify the colour and position its name
      wid1 = strlen(ColourNames[Colour*2]);
      TextX1 = shape[0].x + ((XDim - (wid1*normalfont->charwidth))/2);
      TextY1 = shape[0].y + ((YDim - normalfont->charheight)/2);
      wid2 = strlen(ColourNames[(Colour*2)+1]);
      TextX2 = shape[0].x + ((XDim - (wid2*normalfont->charwidth))/2);
      if (wid1 == 0)
      {
         TextY2 = TextY1;
      }
      else
      {
         TextY1 = TextY1 - (normalfont->charheight/2);
         TextY2 = TextY1 + normalfont->charheight;
         PGL_text(TextX1,TextY1,ColourNames[Colour*2],normalfont);
      }
      PGL_text(TextX2,TextY2,ColourNames[(Colour*2)+1],normalfont);

      // point to next rectangle
      if((X1+=XDim) > XDim*4)
         {
         X1 = XStart;
         Y1 += YDim;
         }
      }

   // return to caller
   return(0);
   }

/*
 *****************************************************************************
 */

void DrawStar(int X1, int Y1, int X2, int Y2)
   // 
   // X1,X2,Y1,Y2 -- these variables define the square area in which to draw
   //                the star pattern.
   //
   {
   // local variables
   int XCntr, YCntr, XOne, YOne, XTwo, YTwo, YHalf;

   // x and y dimensions must be the same for the 45 degree lines, so
   // base line length on the Y dimensions which will be smaller than the X
   if((Y2-Y1)%2 == 1)
      // if Y axis is not even length, make it even!
      Y1++;
   YOne = Y1;
   YTwo = Y2;
   YHalf = (YTwo - YOne)/2;
   if((X2-X1)%2 == 1)
      // if X axis is not even length, make it even!
      X1++;
   XCntr = X1 + (X2 - X1)/2;
   YCntr = Y1 + (Y2 - Y1)/2;
   XOne = XCntr - YHalf;
   XTwo = XCntr + YHalf;

   // draw horizontal line
   PGL_drawline(XOne, YCntr, XTwo, YCntr);
   // draw vertical line
   PGL_drawline(XCntr, YOne, XCntr, YTwo);
   // draw diagonal line, top left to bottom right
   PGL_drawline(XOne, YOne, XTwo, YTwo);
   // draw diagonal line, bottom left to top right
   PGL_drawline(XOne, YTwo, XTwo, YOne);
   }

/*
 *****************************************************************************
 */

int StaticLine(void)
   //
   // StaticLine -- displays static line patterns.
   //
   {
   // local variables
   int qx, qy;
   int length;

   // determine shortest quarter
   qx = (MaxRX - MinRX) / 4;
   qy = (MaxRY - MinRY) / 4;
   if (qy > qx)
   {
      length = qx - 2;
   }
   else
   {
      length = qy - 2;
   }

   // draw a star in the upper left corner
   PGL_setfgcolor(PGL_getcolorcode(LIGHTRED));
   PGL_setlinetype(SOLID_LINE);
   DrawStar(qx-length+MinRX+1, qy-length+MinRY+1, qx+length+MinRX, qy+length+MinRY);
   PGL_text(MinRX, (YCenter/2)-normalfont->charheight, "Light red star", normalfont);
   PGL_text(MinRX, YCenter/2, "in solid lines.", normalfont);

   // draw a start in the upper right corner
   PGL_setfgcolor(PGL_getcolorcode(LIGHTGREEN));
   PGL_setlinetype(DASH_DOT_LINE);
   DrawStar(MaxRX-qx-length+1, qy-length+MinRY+1, MaxRX-qx+length, qy+length+MinRY);
   PGL_text(XCenter, (YCenter/2)-normalfont->charheight, "Light green star", normalfont);
   PGL_text(XCenter, YCenter/2, "in dash dot lines.", normalfont);

   // draw a start in the lower left corner
   PGL_setfgcolor(PGL_getcolorcode(LIGHTBLUE));
   PGL_setlinetype(LONG_DASH_LINE);
   DrawStar(qx-length+MinRX+1, MaxRY-qy-length+1, qx+length+MinRX, MaxRY-qy+length);
   PGL_text(MinRX, MaxRY-(YCenter/2)-normalfont->charheight, "Light blue star", normalfont);
   PGL_text(MinRX, MaxRY-(YCenter/2), "in long dash lines.", normalfont);

   // draw a star in the lower right corner
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   PGL_setlinetype(DOTTED_LINE);
   DrawStar(MaxRX-qx-length+1, MaxRY-qy-length+1, MaxRX-qx+length, MaxRY-qy+length);
   PGL_text(XCenter, MaxRY-(YCenter/2)-normalfont->charheight, "White star", normalfont);
   PGL_text(XCenter, MaxRY-(YCenter/2), "in dotted lines.", normalfont);

   return (0);
   }

/*
 *****************************************************************************
 */
int StaticOpenRect(void)
   //
   // StaticOpenRect -- displays static open rectangles
   //
   {
   // local variables
   PGL_point shape[5];

   int RectCount;
   int X1, X2, Y1, Y2;
   int XLength, YLength;
   int XStart, YStart;
   int TextX, TextY;
   int TextX1, TextY1, TextX2, TextY2;
   int wid1, wid2;

   // draw pattern of rects in upper left corner
   // pattern of small rects, each in different colour, 4x4, all solid lines

   // determine rect dimensions
   X1 = MinRX;
   X2 = XCenter;
   Y1 = MinRY;
   Y2 = YCenter;
   // make sure X and Y dimensions are odd length
   if((X2-X1)%2 == 0)
      X1++;
   if((Y2-Y1)%2 == 0)
      Y1++;
   // determine dimensions of each small rect
   XLength = (X2-X1)/4;
   YLength = (Y2-Y1)/4;
   XLength--;
   YLength--;
   XStart = X1;
   YStart = Y1;
   // draw the rect pattern
   PGL_setlinetype(DOTTED_LINE);
   TextX = X1 + (XLength-(strlen("Dotted")*normalfont->charwidth))/2;
   TextY = Y1 + (YLength - (2*normalfont->charheight))/2;
   PGL_text(TextX,TextY,"Dotted",normalfont);
   PGL_text(TextX,TextY+15,"Lines",normalfont);

   for(RectCount = 0; RectCount < 16; RectCount++)
   {
      // set the color
      PGL_setfgcolor(PGL_getcolorcode(RectCount));

      // set the coordinates for all 5 points
      shape[0].x = X1;
      shape[0].y = Y1;
      shape[1].x = X1+XLength;
      shape[1].y = shape[0].y;
      shape[2].x = shape[1].x;
      shape[2].y = Y1+YLength;
      shape[3].x = shape[0].x;
      shape[3].y = shape[2].y;
      shape[4].x = shape[0].x;
      shape[4].y = shape[0].y;

      // draw the rectangle
      PGL_drawpolyline(4,shape);

      // identify the colour
      if(RectCount != 0)
      {
         // identify the colour and position its name
         wid1 = strlen(ColourNames[RectCount*2]);
         TextX1 = shape[0].x + ((XLength - (wid1*normalfont->charwidth))/2);
         TextY1 = shape[0].y + ((YLength - normalfont->charheight)/2);
         wid2 = strlen(ColourNames[(RectCount*2)+1]);
         TextX2 = shape[0].x + ((XLength - (wid2*normalfont->charwidth))/2);
         if (wid1 == 0)
         {
            TextY2 = TextY1;
         }
         else
         {
            TextY1 = TextY1 - (normalfont->charheight/2);
            TextY2 = TextY1 + normalfont->charheight;
            PGL_text(TextX1,TextY1,ColourNames[RectCount*2],normalfont);
         }
         PGL_text(TextX2,TextY2,ColourNames[(RectCount*2)+1],normalfont);
      }

      // point to next rectangle
      if((X1+=XLength+1) > (XLength+1)*4)
      {
         X1 = XStart;
         Y1 += YLength+1;
      }
   }

   // draw pattern of rects in upper right corner
   // three horizontal rects, each with 4 nested rects inside -- total of 16
   // each nested group in own colour and line style
   X1 = XCenter;
   X2 = MaxRX;
   Y1 = MinRY+1;
   Y2 = YCenter;
   XLength = X2 - X1;
   YLength = (Y2 - Y1)/3 - 3;
   XStart = XLength / 10;
   YStart = YLength / 10;
   Y1+=2;

   // set the color
   PGL_setfgcolor(PGL_getcolorcode(LIGHTRED));
   PGL_setlinetype(LONG_DASH_LINE);
   for(RectCount = 0; RectCount < 3; RectCount++)
      {
      // set the coordinates for all 5 points
      shape[0].x = X1;
      shape[0].y = Y1;
      shape[1].x = X1+XLength;
      shape[1].y = shape[0].y;
      shape[2].x = shape[1].x;
      shape[2].y = Y1+YLength;
      shape[3].x = shape[0].x;
      shape[3].y = shape[2].y;
      shape[4].x = shape[0].x;
      shape[4].y = shape[0].y;

      // draw the rectangle
      PGL_drawpolyline(4,shape);

      // point to next rectangle
      X1 += XStart;
      XLength -= XStart*2;
      Y1 += YStart;
      YLength -= YStart*2;
      }

   //identify colour and line pattern
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("long dash lines. ")*normalfont->charwidth))/2;
   TextY = shape[0].y + (YLength - normalfont->charheight)/2;
   PGL_text(TextX,TextY,"Light red",normalfont);
   PGL_text(TextX,TextY+15,"long dash lines.",normalfont);


   // draw second set of rects
   X1 = XCenter;
   Y1 = MinRY+1;
   XLength = X2 - X1;
   YLength = (Y2 - Y1)/3 - 3;
   Y1 = MinRY+YLength+5;

   // set the color
   PGL_setfgcolor(PGL_getcolorcode(LIGHTGREEN));
   PGL_setlinetype(SHORT_DASHED_LINE);
   for(RectCount = 0; RectCount < 3; RectCount++)
      {
      // set the coordinates for all 5 points
      shape[0].x = X1;
      shape[0].y = Y1;
      shape[1].x = X1+XLength;
      shape[1].y = shape[0].y;
      shape[2].x = shape[1].x;
      shape[2].y = Y1+YLength;
      shape[3].x = shape[0].x;
      shape[3].y = shape[2].y;
      shape[4].x = shape[0].x;
      shape[4].y = shape[0].y;

      // draw the rectangle
      PGL_drawpolyline(4,shape);

      // point to next rectangle
      X1 += XStart;
      XLength -= XStart*2;
      Y1 += YStart;
      YLength -= YStart*2;
      }

   //identify colour and line pattern
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("short dash lines.")*normalfont->charwidth))/2;
   TextY = shape[0].y + (YLength - normalfont->charheight)/2;
   PGL_text(TextX,TextY,"Light green",normalfont);
   PGL_text(TextX,TextY+15,"short dash lines.",normalfont);

   // draw third set of rects
   X1 = XCenter;
   Y1 = MinRY;
   XLength = X2 - X1;
   YLength = (Y2 - Y1)/3 - 3;
   Y1 = MinRY+(YLength*2)+5;

   // set the color
   PGL_setfgcolor(PGL_getcolorcode(LIGHTBLUE));
   PGL_setlinetype(DASH_DOT_LINE);
   for(RectCount = 0; RectCount < 3; RectCount++)
      {
      // set the coordinates for all 5 points
      shape[0].x = X1;
      shape[0].y = Y1;
      shape[1].x = X1+XLength;
      shape[1].y = shape[0].y;
      shape[2].x = shape[1].x;
      shape[2].y = Y1+YLength;
      shape[3].x = shape[0].x;
      shape[3].y = shape[2].y;
      shape[4].x = shape[0].x;
      shape[4].y = shape[0].y;

      // draw the rectangle
      PGL_drawpolyline(4,shape);

      // point to next rectangle
      X1 += XStart;
      XLength -= XStart*2;
      Y1 += YStart;
      YLength -= YStart*2;
      }

   //identify colour and line pattern
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("dash dot lines.  ")*normalfont->charwidth))/2;
   TextY = shape[0].y + (YLength - normalfont->charheight)/2;
   PGL_text(TextX,TextY,"Light blue",normalfont);
   PGL_text(TextX,TextY+15,"dash dot lines.",normalfont);

   // draw pattern of rects in lower half of screen
   // solid line, single colour rects nested with one line between each rect
   X1 = MinRX;
   X2 = MaxRX;
   Y1 = YCenter+1;
   Y2 = MaxRY+1;
   XLength = X2 - X1;
   YLength = Y2 - Y1;

   // set the line style
   PGL_setlinetype(SOLID_LINE);
   RectCount = 0;

   do
      {
      // set the color
      PGL_setfgcolor(PGL_getcolorcode(RectCount));

      // set the coordinates for all 5 points
      shape[0].x = X1;
      shape[0].y = Y1;
      shape[1].x = X1+XLength;
      shape[1].y = shape[0].y;
      shape[2].x = shape[1].x;
      shape[2].y = Y1+YLength;
      shape[3].x = shape[0].x;
      shape[3].y = shape[2].y;
      shape[4].x = shape[0].x;
      shape[4].y = shape[0].y;

      // draw the rectangle
      PGL_drawpolyline(4,shape);

      // calc coords for next coordinate
      X1 += 2;
      X2 -= 2;
      XLength -= 4;
      Y1 += 2;
      Y2 -= 2;
      YLength -= 4;

      // get next colour
      if(++RectCount > WHITE)
         RectCount = 0;
      }
   while(X1+15 < X2 && Y1+15 < Y2);

   // identify line style and colours
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("Solid lines in all 16 PGL colours.")*normalfont->charwidth))/2;
   TextY = shape[0].y + (YLength - normalfont->charheight)/2;
   PGL_text(TextX,TextY+3,"Solid lines in all 16 PGL colours.",normalfont);

   // return to caller
   return (0);
   }

/*
 *****************************************************************************
 */

int StaticSolidRect(void)
   {
   // local variables
   int RectCount, X1, X2, Y1, Y2, XLength, YLength, Colour;

   // draw 16 horizontal rects across the top half of the screen 
   X1 = MinRX;
   X2 = MaxRX;
   Y1 = MinRY;
   Y2 = YCenter;
   // make sure Y dimensions are even length
   if((Y2-Y1)%2 != 0)
      Y1++;
   XLength = X2-X1;
   YLength = (Y2-Y1)/16 - 1;

   // draw the rectangle pattern
   for(RectCount = 0; RectCount<16; RectCount++)
      {
      // set the color
      PGL_setfgcolor(PGL_getcolorcode(RectCount));

      // draw the rectangle
      PGL_drawrect(X1, Y1, XLength+1, YLength+1);

      // point to next rectangle
      Y1 += YLength+1;
      }

   // draw 64 vertical bars across the bottom half of the screen, cycling 
   // through colours
   X1 = MinRX;
   X2 = MaxRX;
   Y1 = YCenter;
   Y2 = MaxRY;
   // make sure X dimensions are even length
   if((X2-X1)%2 != 0)
      X1++;
   XLength = (X2-X1)/32 - 1;
   X1 += ((X2-X1) - (32 * (XLength+1))) / 2;
   YLength = Y2-Y1;
   // draw the rectangle pattern
   Colour = 0;
   for(RectCount = 0; RectCount<32; RectCount++)
      {
      // set the color
      PGL_setfgcolor(PGL_getcolorcode(Colour));

      // draw the rectangle
      PGL_drawrect(X1, Y1, XLength+1, YLength+1);

      // point to next rectangle
      X1 += XLength+1;

      // prepare next colour
      if(++Colour > WHITE)
         Colour = 0;
      }

   // return to caller
   return (0);
   }

/*
 *****************************************************************************
 */

int StaticPatternRect(void)
   {
   // local variables
   int RectCount, X1, X2, Y1, Y2, XLength, YLength, Colour;

   // turn on pattern fill
   SetPatternFill();

   // draw 16 horizontal rects across the top half of the screen 
   X1 = MinRX;
   X2 = MaxRX;
   Y1 = MinRY;
   Y2 = YCenter;
   // make sure Y dimensions are even length
   if((Y2-Y1)%2 != 0)
      Y1++;
   XLength = X2-X1;
   YLength = (Y2-Y1)/16 - 1;

   // draw the rectangle pattern
   for(RectCount = 0; RectCount<16; RectCount++)
      {
      // set the color
      PGL_setfgcolor(PGL_getcolorcode(RectCount));
      PGL_setbgcolor(PGL_getcolorcode(RectCount+1));

      // draw the rectangle
      PGL_drawrect(X1, Y1, XLength+1, YLength+1);

      // point to next rectangle
      Y1 += YLength+1;
      }


   // draw 64 vertical bars across the bottom half of the screen, cycling 
   // through colours
   X1 = MinRX;
   X2 = MaxRX;
   Y1 = YCenter;
   Y2 = MaxRY;
   // make sure X dimensions are even length
   if((X2-X1)%2 != 0)
      X1++;

   XLength = (X2-X1)/32 - 1;
   X1 += ((X2-X1) - (32 * (XLength+1))) / 2;
   YLength = Y2-Y1;
   // draw the rectangle pattern
   Colour = 0;
   for(RectCount = 0; RectCount<32; RectCount++)
      {
      // set the color
      PGL_setfgcolor(PGL_getcolorcode(Colour));
      PGL_setbgcolor(PGL_getcolorcode(Colour+1));

      // draw the rectangle
      PGL_drawrect(X1, Y1, XLength+1, YLength+1);

      // point to next rectangle
      X1 += XLength+1;

      // prepare next colour
      if(++Colour > WHITE)
         Colour = 0;
      }

   // turn on solid fill
   SetSolidFill();
   PGL_setbgcolor(PGL_getcolorcode(DARKBLUE));

   // return to caller
   return (0);
   }
/*
 *****************************************************************************
 */

int StaticOpenPoly(void)
   //
   // StaticOpenPoly -- displays static polygons.- 8 in all.
   //
   {
   // local variables
   PGL_point shape[12];
   int XDim, YDim, X1, X2, Y1, Y2, TextX, TextY;

   // divide display into 8 sections, one polygon goes in each
   X1 = MinRX;
   X2 = MaxRX;
   Y1 = MinRY;
   Y2 = MaxRY;

   // make sure dimensions are even length
   if((X2-X1)%2 != 0)
      X1++;
   if((Y2-Y1)%2 != 0)
      Y1++;
   XDim = (X2-X1)/4;
   YDim = (Y2-Y1)/2;

   // draw a three sided polygon in the first area
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   PGL_setlinetype(SOLID_LINE);
   shape[0].x = X1 + (XDim/2);
   shape[0].y = Y1;
   shape[1].x = X1 + XDim;
   shape[1].y = Y1 + YDim;
   shape[2].x = X1;
   shape[2].y = Y1 + YDim;
   shape[3].x = shape[0].x;
   shape[3].y = shape[0].y;
   PGL_drawpolyline(3,shape);

   // identify colour and line pattern
   TextY = shape[0].y + (YDim - normalfont->charheight)/4 * 3;
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("Solid line")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Solid line",normalfont);
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("white")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"white",normalfont);
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("triangle")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+(normalfont->charheight*2),"triangle",normalfont);

   // draw a four sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTRED));
   PGL_setlinetype(SOLID_LINE);
   shape[0].x = X1+XDim+1;
   shape[0].y = Y1;
   shape[1].x = X1+(2*XDim);
   shape[1].y = Y1;
   shape[2].x = X1+(2*XDim);
   shape[2].y = Y1+YDim;
   shape[3].x = shape[0].x;
   shape[3].y = Y1+YDim;
   shape[4].x = shape[0].x;
   shape[4].y = shape[0].y;
   PGL_drawpolyline(4,shape);

   // identify colour and line pattern
   TextY = shape[0].y + (YDim - normalfont->charheight)/4 * 3;
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("Solid line")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Solid line",normalfont);
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("red")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"red",normalfont);
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("rectangle")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+(normalfont->charheight*2),"rectangle",normalfont);

   // draw a five sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTGREEN));
   PGL_setlinetype(SOLID_LINE);
   shape[0].x = X1+(2*XDim)+2;
   shape[0].y = Y1+(YDim/3);
   shape[1].x = shape[0].x + (XDim/2);
   shape[1].y = Y1;
   shape[2].x = shape[0].x + XDim;
   shape[2].y = shape[0].y;
   shape[3].x = shape[0].x + (XDim/4*3);
   shape[3].y = Y1+YDim;
   shape[4].x = shape[0].x + (XDim/4);
   shape[4].y = Y1+YDim;
   shape[5].x = shape[0].x;
   shape[5].y = shape[0].y;
   PGL_drawpolyline(5,shape);
   // identify colour and line pattern
   TextY = shape[1].y + (YDim - normalfont->charheight)/4 * 3;
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("Solid line")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Solid line",normalfont);
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("green")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"green",normalfont);
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("pentagon")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+(normalfont->charheight*2),"pentagon",normalfont);

   // draw a six sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTBLUE));
   PGL_setlinetype(SOLID_LINE);
   shape[0].x = X1+(3*XDim)+3;
   shape[0].y = Y1+(YDim/2);
   shape[1].x = X1+(3*XDim)+XDim/3;
   shape[1].y = Y1;
   shape[2].x = X1+(3*XDim)+XDim/3*2;
   shape[2].y = Y1;
   shape[3].x = X1+(4*XDim);
   shape[3].y = shape[0].y;
   shape[4].x = shape[2].x;
   shape[4].y = Y1+YDim;
   shape[5].x = shape[1].x;
   shape[5].y = shape[4].y;
   shape[6].x = shape[0].x;
   shape[6].y = shape[0].y;
   PGL_drawpolyline(6,shape);
   // identify colour and line pattern
   TextY = shape[1].y + (YDim - normalfont->charheight)/4 * 3;
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("Solid line")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Solid line",normalfont);
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("blue")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"blue",normalfont);
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("hexagon")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+(normalfont->charheight*2),"hexagon",normalfont);


   // repeat in lower half of the screen
   Y1 += YDim+4;

   // draw a six sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTBLUE));
   PGL_setlinetype(DOTTED_LINE);
   shape[0].x = X1;
   shape[0].y = Y1+(YDim/2);
   shape[1].x = X1+XDim/3;
   shape[1].y = Y1;
   shape[2].x = X1+XDim/3*2;
   shape[2].y = Y1;
   shape[3].x = X1+XDim;
   shape[3].y = shape[0].y;
   shape[4].x = shape[2].x;
   shape[4].y = Y1+YDim;
   shape[5].x = shape[1].x;
   shape[5].y = shape[4].y;
   shape[6].x = shape[0].x;
   shape[6].y = shape[0].y;
   PGL_drawpolyline(6,shape);
   // identify colour and line pattern
   TextY = shape[1].y + (YDim - normalfont->charheight)/4;
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("Dotted line")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Dotted line",normalfont);
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("blue")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"blue",normalfont);
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("hexagon")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+(normalfont->charheight*2),"hexagon",normalfont);

   // draw a five sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTGREEN));
   PGL_setlinetype(SHORT_DASHED_LINE);
   shape[0].x = X1+XDim+1;
   shape[0].y = Y1+(YDim/3*2);
   shape[1].x = shape[0].x + (XDim/2);
   shape[1].y = Y1+YDim;
   shape[2].x = shape[0].x + XDim;
   shape[2].y = shape[0].y;
   shape[3].x = shape[0].x + (XDim/4*3);
   shape[3].y = Y1;
   shape[4].x = shape[0].x + (XDim/4);
   shape[4].y = Y1;
   shape[5].x = shape[0].x;
   shape[5].y = shape[0].y;
   PGL_drawpolyline(5,shape);
   // identify colour and line pattern
   TextY = shape[4].y + (YDim - normalfont->charheight)/4;
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("Short")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Short",normalfont);
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("dash line")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"dash line",normalfont);
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("green")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+(normalfont->charheight*2),"green",normalfont);
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("pentagon")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+(normalfont->charheight*3),"pentagon",normalfont);

   // draw a four sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTRED));
   PGL_setlinetype(DOUBLE_DOTTED_LINE);
   shape[0].x = X1+(XDim*2)+2;
   shape[0].y = Y1;
   shape[1].x = X1+(3*XDim);
   shape[1].y = Y1;
   shape[2].x = X1+(3*XDim);
   shape[2].y = Y1+YDim;
   shape[3].x = shape[0].x;
   shape[3].y = Y1+YDim;
   shape[4].x = shape[0].x;
   shape[4].y = shape[0].y;
   PGL_drawpolyline(4,shape);
   // identify colour and line pattern
   TextY = shape[0].y + (YDim - normalfont->charheight)/4;
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("Double")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Double",normalfont);
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("dot line")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"dot line",normalfont);
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("red")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+(normalfont->charheight*2),"red",normalfont);
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("rectangle")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+(normalfont->charheight*3),"rectangle",normalfont);

   // draw a three sided polygon 
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   PGL_setlinetype(DOUBLE_DOTTED_LINE);
   shape[0].x = X1 + (3*XDim)+ 3 + (XDim/2);
   shape[0].y = Y1 + YDim;
   shape[1].x = X1 + 4 * XDim;
   shape[1].y = Y1;
   shape[2].x = X1 + (3*XDim) + 3;
   shape[2].y = Y1;
   shape[3].x = shape[0].x;
   shape[3].y = shape[0].y;
   PGL_drawpolyline(3,shape);
   // identify colour and line pattern
   TextY = shape[1].y + (YDim - normalfont->charheight)/4;
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("Double")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Double",normalfont);
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("dot line")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"dot line",normalfont);
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("white")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+(normalfont->charheight*2),"white",normalfont);
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("triangle")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+(normalfont->charheight*3),"triangle",normalfont);

   return (0);
   }

/*
 *****************************************************************************
 */


int StaticSolidPoly(void)
   //
   // StaticOpenPoly -- displays static polygons.- 8 in all.
   //
   {
   // local variables
   PGL_point shape[12];
   int XDim, YDim, X1, X2, Y1, Y2, TextX, TextY;

   // divide display into 8 sections, one polygon goes in each
   X1 = MinRX;
   X2 = MaxRX;
   Y1 = MinRY;
   Y2 = MaxRY;

   // make sure dimensions are even length
   if((X2-X1)%2 != 0)
      X1++;
   if((Y2-Y1)%2 != 0)
      Y1++;
   XDim = (X2-X1)/4;
   YDim = (Y2-Y1)/2;

   // draw a three sided polygon in the first area
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   shape[0].x = X1 + (XDim/2);
   shape[0].y = Y1;
   shape[1].x = X1 + XDim;
   shape[1].y = Y1 + YDim;
   shape[2].x = X1;
   shape[2].y = Y1 + YDim;
   shape[3].x = shape[0].x;
   shape[3].y = shape[0].y;
   PGL_drawpolygon(3,shape);
   // identify colour and line pattern
   PGL_setfgcolor(PGL_getcolorcode(BLACK));
   TextY = shape[0].y + (YDim - normalfont->charheight)/4 * 3;
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("White")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"White",normalfont);
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("triangle")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"triangle",normalfont);

   // draw a four sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTRED));
   shape[0].x = X1+XDim+1;
   shape[0].y = Y1;
   shape[1].x = X1+(2*XDim);
   shape[1].y = Y1;
   shape[2].x = X1+(2*XDim);
   shape[2].y = Y1+YDim;
   shape[3].x = shape[0].x;
   shape[3].y = Y1+YDim;
   shape[4].x = shape[0].x;
   shape[4].y = shape[0].y;
   PGL_drawpolygon(4,shape);
   // identify colour and line pattern
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   TextY = shape[0].y + (YDim - normalfont->charheight)/4 * 3;
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("Red")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Red",normalfont);
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("rectangle")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"rectangle",normalfont);

   // draw a five sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTGREEN));
   shape[0].x = X1+(2*XDim)+2;
   shape[0].y = Y1+(YDim/3);
   shape[1].x = shape[0].x + (XDim/2);
   shape[1].y = Y1;
   shape[2].x = shape[0].x + XDim;
   shape[2].y = shape[0].y;
   shape[3].x = shape[0].x + (XDim/4*3);
   shape[3].y = Y1+YDim;
   shape[4].x = shape[0].x + (XDim/4);
   shape[4].y = Y1+YDim;
   shape[5].x = shape[0].x;
   shape[5].y = shape[0].y;
   PGL_drawpolygon(5,shape);
   // identify colour and line pattern
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   TextY = shape[1].y + (YDim - normalfont->charheight)/4 * 3;
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("Green")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Green",normalfont);
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("pentagon")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"pentagon",normalfont);

   // draw a six sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTBLUE));
   shape[0].x = X1+(3*XDim)+3;
   shape[0].y = Y1+(YDim/2);
   shape[1].x = X1+(3*XDim)+XDim/3;
   shape[1].y = Y1;
   shape[2].x = X1+(3*XDim)+XDim/3*2;
   shape[2].y = Y1;
   shape[3].x = X1+(4*XDim);
   shape[3].y = shape[0].y;
   shape[4].x = shape[2].x;
   shape[4].y = Y1+YDim;
   shape[5].x = shape[1].x;
   shape[5].y = shape[4].y;
   shape[6].x = shape[0].x;
   shape[6].y = shape[0].y;
   PGL_drawpolygon(6,shape);
   // identify colour and line pattern
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   TextY = shape[1].y + (YDim - normalfont->charheight)/4 * 3;
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("Blue")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Blue",normalfont);
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("hexagon")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"hexagon",normalfont);


   // repeat in lower half of the screen
   Y1 += YDim+4;

   // draw a six sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTBLUE));
   shape[0].x = X1;
   shape[0].y = Y1+(YDim/2);
   shape[1].x = X1+XDim/3;
   shape[1].y = Y1;
   shape[2].x = X1+XDim/3*2;
   shape[2].y = Y1;
   shape[3].x = X1+XDim;
   shape[3].y = shape[0].y;
   shape[4].x = shape[2].x;
   shape[4].y = Y1+YDim;
   shape[5].x = shape[1].x;
   shape[5].y = shape[4].y;
   shape[6].x = shape[0].x;
   shape[6].y = shape[0].y;
   PGL_drawpolygon(6,shape);
   // identify colour and line pattern
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   TextY = shape[1].y + (YDim - normalfont->charheight)/4;
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("Blue")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Blue",normalfont);
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("hexagon")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"hexagon",normalfont);

   // draw a five sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTGREEN));
   shape[0].x = X1+XDim+1;
   shape[0].y = Y1+(YDim/3*2);
   shape[1].x = shape[0].x + (XDim/2);
   shape[1].y = Y1+YDim;
   shape[2].x = shape[0].x + XDim;
   shape[2].y = shape[0].y;
   shape[3].x = shape[0].x + (XDim/4*3);
   shape[3].y = Y1;
   shape[4].x = shape[0].x + (XDim/4);
   shape[4].y = Y1;
   shape[5].x = shape[0].x;
   shape[5].y = shape[0].y;
   PGL_drawpolygon(5,shape);
   // identify colour and line pattern
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   TextY = shape[4].y + (YDim - normalfont->charheight)/4;
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("Green")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Green",normalfont);
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("pentagon")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"pentagon",normalfont);

   // draw a four sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTRED));
   shape[0].x = X1+(XDim*2)+2;
   shape[0].y = Y1;
   shape[1].x = X1+(3*XDim);
   shape[1].y = Y1;
   shape[2].x = X1+(3*XDim);
   shape[2].y = Y1+YDim;
   shape[3].x = shape[0].x;
   shape[3].y = Y1+YDim;
   shape[4].x = shape[0].x;
   shape[4].y = shape[0].y;
   PGL_drawpolygon(4,shape);
   // identify colour and line pattern
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   TextY = shape[0].y + (YDim - normalfont->charheight)/4;
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("Red")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Red",normalfont);
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("rectangle")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"rectangle",normalfont);

   // draw a three sided polygon 
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   shape[0].x = X1 + (3*XDim)+ 3 + (XDim/2);
   shape[0].y = Y1 + YDim;
   shape[1].x = X1 + 4 * XDim;
   shape[1].y = Y1;
   shape[2].x = X1 + (3*XDim) + 3;
   shape[2].y = Y1;
   shape[3].x = shape[0].x;
   shape[3].y = shape[0].y;
   PGL_drawpolygon(3,shape);
   // identify colour and line pattern
   PGL_setfgcolor(PGL_getcolorcode(BLACK));
   TextY = shape[1].y + (YDim - normalfont->charheight)/4;
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("White")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"White",normalfont);
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("triangle")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"triangle",normalfont);

   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   PGL_setbgcolor(PGL_getcolorcode(DARKBLUE));

   return (0);
   }

/*
 *****************************************************************************
 */

int StaticPatternPoly(void)
   //
   // StaticOpenPoly -- displays static polygons.- 8 in all.
   //
   {
   // local variables
   PGL_point shape[12];
   int XDim, YDim, X1, X2, Y1, Y2, TextX, TextY;

   // turn on pattern fill
   SetPatternFill();

   // divide display into 8 sections, one polygon goes in each
   X1 = MinRX;
   X2 = MaxRX;
   Y1 = MinRY;
   Y2 = MaxRY;

   // make sure dimensions are even length
   if((X2-X1)%2 != 0)
      X1++;
   if((Y2-Y1)%2 != 0)
      Y1++;
   XDim = (X2-X1)/4;
   YDim = (Y2-Y1)/2;

   // draw a three sided polygon in the first area
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   PGL_setbgcolor(PGL_getcolorcode(LIGHTGRAY));
   shape[0].x = X1 + (XDim/2);
   shape[0].y = Y1;
   shape[1].x = X1 + XDim;
   shape[1].y = Y1 + YDim;
   shape[2].x = X1;
   shape[2].y = Y1 + YDim;
   shape[3].x = shape[0].x;
   shape[3].y = shape[0].y;
   PGL_drawpolygon(3,shape);
   // identify colour and pattern
   PGL_setfgcolor(PGL_getcolorcode(BLACK));
   PGL_setbgcolor(PGL_getcolorcode(WHITE));
   TextY = shape[0].y + (YDim - normalfont->charheight)/4 * 3;
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("White")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"White",normalfont);
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("triangle")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"triangle",normalfont);

   // draw a four sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTRED));
   PGL_setbgcolor(PGL_getcolorcode(DARKRED));
   shape[0].x = X1+XDim+1;
   shape[0].y = Y1;
   shape[1].x = X1+(2*XDim);
   shape[1].y = Y1;
   shape[2].x = X1+(2*XDim);
   shape[2].y = Y1+YDim;
   shape[3].x = shape[0].x;
   shape[3].y = Y1+YDim;
   shape[4].x = shape[0].x;
   shape[4].y = shape[0].y;
   PGL_drawpolygon(4,shape);
   // identify colour and pattern
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   PGL_setbgcolor(PGL_getcolorcode(LIGHTRED));
   TextY = shape[0].y + (YDim - normalfont->charheight)/4 * 3;
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("Red")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Red",normalfont);
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("rectangle")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"rectangle",normalfont);

   // draw a five sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTGREEN));
   PGL_setbgcolor(PGL_getcolorcode(DARKGREEN));
   shape[0].x = X1+(2*XDim)+2;
   shape[0].y = Y1+(YDim/3);
   shape[1].x = shape[0].x + (XDim/2);
   shape[1].y = Y1;
   shape[2].x = shape[0].x + XDim;
   shape[2].y = shape[0].y;
   shape[3].x = shape[0].x + (XDim/4*3);
   shape[3].y = Y1+YDim;
   shape[4].x = shape[0].x + (XDim/4);
   shape[4].y = Y1+YDim;
   shape[5].x = shape[0].x;
   shape[5].y = shape[0].y;
   PGL_drawpolygon(5,shape);
   // identify colour and line pattern
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   PGL_setbgcolor(PGL_getcolorcode(LIGHTGREEN));
   TextY = shape[1].y + (YDim - normalfont->charheight)/4 * 3;
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("Green")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Green",normalfont);
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("pentagon")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"pentagon",normalfont);

   // draw a six sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTBLUE));
   PGL_setbgcolor(PGL_getcolorcode(DARKBLUE));
   shape[0].x = X1+(3*XDim)+3;
   shape[0].y = Y1+(YDim/2);
   shape[1].x = X1+(3*XDim)+XDim/3;
   shape[1].y = Y1;
   shape[2].x = X1+(3*XDim)+XDim/3*2;
   shape[2].y = Y1;
   shape[3].x = X1+(4*XDim);
   shape[3].y = shape[0].y;
   shape[4].x = shape[2].x;
   shape[4].y = Y1+YDim;
   shape[5].x = shape[1].x;
   shape[5].y = shape[4].y;
   shape[6].x = shape[0].x;
   shape[6].y = shape[0].y;
   PGL_drawpolygon(6,shape);
   // identify colour and pattern
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   PGL_setbgcolor(PGL_getcolorcode(LIGHTBLUE));
   TextY = shape[1].y + (YDim - normalfont->charheight)/4 * 3;
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("Blue")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Blue",normalfont);
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("hexagon")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"hexagon",normalfont);


   // repeat in lower half of the screen
   Y1 += YDim+4;

   // draw a six sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTBLUE));
   PGL_setbgcolor(PGL_getcolorcode(DARKBLUE));
   shape[0].x = X1;
   shape[0].y = Y1+(YDim/2);
   shape[1].x = X1+XDim/3;
   shape[1].y = Y1;
   shape[2].x = X1+XDim/3*2;
   shape[2].y = Y1;
   shape[3].x = X1+XDim;
   shape[3].y = shape[0].y;
   shape[4].x = shape[2].x;
   shape[4].y = Y1+YDim;
   shape[5].x = shape[1].x;
   shape[5].y = shape[4].y;
   shape[6].x = shape[0].x;
   shape[6].y = shape[0].y;
   PGL_drawpolygon(6,shape);
   // identify colour and line pattern
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   PGL_setbgcolor(PGL_getcolorcode(LIGHTBLUE));
   TextY = shape[1].y + (YDim - normalfont->charheight)/4;
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("Blue")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Blue",normalfont);
   TextX = shape[0].x + (shape[3].x-shape[0].x-(strlen("hexagon")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"hexagon",normalfont);

   // draw a five sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTGREEN));
   PGL_setbgcolor(PGL_getcolorcode(DARKGREEN));
   shape[0].x = X1+XDim+1;
   shape[0].y = Y1+(YDim/3*2);
   shape[1].x = shape[0].x + (XDim/2);
   shape[1].y = Y1+YDim;
   shape[2].x = shape[0].x + XDim;
   shape[2].y = shape[0].y;
   shape[3].x = shape[0].x + (XDim/4*3);
   shape[3].y = Y1;
   shape[4].x = shape[0].x + (XDim/4);
   shape[4].y = Y1;
   shape[5].x = shape[0].x;
   shape[5].y = shape[0].y;
   PGL_drawpolygon(5,shape);
   // identify colour and line pattern
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   PGL_setbgcolor(PGL_getcolorcode(LIGHTGREEN));
   TextY = shape[4].y + (YDim - normalfont->charheight)/4;
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("Green")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Green",normalfont);
   TextX = shape[0].x + (shape[2].x-shape[0].x-(strlen("pentagon")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"pentagon",normalfont);

   // draw a four sided polygon
   PGL_setfgcolor(PGL_getcolorcode(LIGHTRED));
   PGL_setbgcolor(PGL_getcolorcode(DARKRED));
   shape[0].x = X1+(XDim*2)+2;
   shape[0].y = Y1;
   shape[1].x = X1+(3*XDim);
   shape[1].y = Y1;
   shape[2].x = X1+(3*XDim);
   shape[2].y = Y1+YDim;
   shape[3].x = shape[0].x;
   shape[3].y = Y1+YDim;
   shape[4].x = shape[0].x;
   shape[4].y = shape[0].y;
   PGL_drawpolygon(4,shape);
   // identify colour and line pattern
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   PGL_setbgcolor(PGL_getcolorcode(LIGHTRED));
   TextY = shape[0].y + (YDim - normalfont->charheight)/4;
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("Red")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"Red",normalfont);
   TextX = shape[0].x + (shape[1].x-shape[0].x-(strlen("rectangle")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"rectangle",normalfont);

   // draw a three sided polygon 
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   PGL_setbgcolor(PGL_getcolorcode(LIGHTGRAY));
   shape[0].x = X1 + (3*XDim)+ 3 + (XDim/2);
   shape[0].y = Y1 + YDim;
   shape[1].x = X1 + 4 * XDim;
   shape[1].y = Y1;
   shape[2].x = X1 + (3*XDim) + 3;
   shape[2].y = Y1;
   shape[3].x = shape[0].x;
   shape[3].y = shape[0].y;
   PGL_drawpolygon(3,shape);
   // identify colour and line pattern
   PGL_setfgcolor(PGL_getcolorcode(BLACK));
   PGL_setbgcolor(PGL_getcolorcode(WHITE));
   TextY = shape[1].y + (YDim - normalfont->charheight)/4;
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("White")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY,"White",normalfont);
   TextX = shape[2].x + (shape[1].x-shape[2].x-(strlen("triangle")*normalfont->charwidth))/2;
   PGL_text(TextX,TextY+normalfont->charheight,"triangle",normalfont);

   // turn on solid fill
   SetSolidFill();
   PGL_setfgcolor(PGL_getcolorcode(WHITE));
   PGL_setbgcolor(PGL_getcolorcode(DARKBLUE));

   return (0);
   }

/*
 *****************************************************************************
 */

int StaticScreenBlit(void)
   //
   // StaticScreenBlit -- Grabs a portion of the screen and blits it to another
   //                     part of the screen.
   //
   {
   // local variables
   int Height, Width, SrcLeft, SrcTop, DestLeft, DestTop, XStart, YStart,
       XDim, YDim, X1, Y1, Rectangle;
   char BlitKey[] = "Press any key for blit demo.";


   // determine dimensions of rects in 4 x 4 display of colours
   XStart = MinRX;
   YStart = MinRY;
   if((XCenter-MinRX)%2 == 1)
      {
      // X dimension is odd, make it even
      XStart++;
      }
   if((MaxRY-MinRY)%2 == 1)
      {
      // Y dimension is odd, make it even
      YStart++;
      }
   XDim = (XCenter - XStart) / 4;
   YDim = (MaxRY - YStart) / 4;
   X1 = XStart;
   Y1 = YStart;

   // wait for key before blit
   PGL_setfgcolor(PGL_getcolorcode(YELLOW));
   PGL_text((modeinfo.xres - (strlen(BlitKey)*8))/2, modeinfo.yres-15, 
            BlitKey, normalfont);
   getch();
   PGL_setfgcolor(PGL_getcolorcode(BLACK));
   PGL_drawrect(2, modeinfo.yres-20, modeinfo.xres - 4, 18);

   // set a static width and height and static starting point
   Width = XDim + 1;
   Height = YDim + 1;

   // copy four of the rectangles from the upper left corner to the lower right
   SrcLeft = XStart;
   SrcTop = YStart;
   DestLeft = XCenter;
   DestTop = YStart + 3 * YDim;

   // loop through the rects to be copied
   for(Rectangle = 0; Rectangle < 4; Rectangle++)
      {
      // do the blit
      PGL_screentoscreenblit(SrcLeft, SrcTop, DestLeft, DestTop, Width, Height);

      // point to next source and dest rectangle
      SrcLeft += XDim;
      SrcTop += YDim;
      DestLeft += XDim;
      DestTop -= YDim;
      }

   // return to caller
   return(0);
   }


/*
 *****************************************************************************
 */

int StaticBufferBlit(void)
   //
   // StaticBufferBlit -- Grabs a portion of the screen and blits it to a ram
   //                   buffer and then to another portion of the screen
   //
   {
   // local variables
   int Height, Width, SrcLeft, SrcTop, DestLeft, DestTop, XStart, YStart,
       XDim, YDim, X1, Y1, Rectangle;
   char BlitKey[] = "Press any key for blit demo.";
   char MemoryError[] = "Not enough memory";
   unsigned long bufsize;

   // determine dimensions of rects in 4 x 4 display of colours
   XStart = MinRX;
   YStart = MinRY;
   if((XCenter-MinRX)%2 == 1)
      {
      // X dimension is odd, make it even
      XStart++;
      }
   if((MaxRY-MinRY)%2 == 1)
      {
      // Y dimension is odd, make it even
      YStart++;
      }
   XDim = (XCenter - XStart) / 4;
   YDim = (MaxRY - YStart) / 4;
   X1 = XStart;
   Y1 = YStart;

   // wait for key before blit
   PGL_setfgcolor(PGL_getcolorcode(YELLOW));
   PGL_text((modeinfo.xres - (strlen(BlitKey)*8))/2, modeinfo.yres-15, 
            BlitKey, normalfont);
   getch();
   PGL_setfgcolor(PGL_getcolorcode(BLACK));
   PGL_drawrect(2, modeinfo.yres-20, modeinfo.xres - 4, 18);

   // set a static width and height and static starting point
   Width = XDim + 1;
   Height = YDim + 1;

   // copy four of the rectangles from the upper left corner to the lower right
   SrcLeft = XStart;
   SrcTop = YStart;
   DestLeft = XCenter;
   DestTop = YStart + 3 * YDim;

   // dynamically allocate necessary CPU memory for operation in dwords
   bufsize = PGL_getbuffersize(Width, Height) * 4;
   BlitBufPtr = (unsigned long huge *) halloc (bufsize, 1);
   if(BlitBufPtr == NULL)
   {
       // display error message
       PGL_setfgcolor(PGL_getcolorcode(YELLOW));
       PGL_text((modeinfo.xres / 2) + (((modeinfo.xres / 2) - (strlen(MemoryError) * largefont->charwidth)) / 2),
                modeinfo.yres / 2,
                MemoryError, largefont);

       // return to caller
       return (1);
   }
   else
   {
       // loop through the rects to be copied
       for(Rectangle = 0; Rectangle < 4; Rectangle++)
       {
          // do the blit to the buffer
          PGL_screentobufferblit(BlitBufPtr, SrcLeft, SrcTop, Width, Height);

          // do the blit to the screen
          PGL_buffertoscreenblit(BlitBufPtr, DestLeft, DestTop, Width, Height);

          // point to next source and dest rectangle
          SrcLeft += XDim;
          SrcTop += YDim;
          DestLeft += XDim;
          DestTop -= YDim;
       }

       // free CPU buffer
       hfree(BlitBufPtr);
   }

   // return to caller
   return(0);
}

/*
 *****************************************************************************
 */

int RandLine(void)
   //
   // RandLine -- displays random lines in random colors and patterns
   //             within the random display area defined by MinRX, MaxRX,
   //             MinRY, MaxRY.
   //
   {
   // local variables
   int   XOne, XTwo, YOne, YTwo;

   // set the X coordinates
   XOne = getrandom(MinRX, MaxRX);
   XTwo = getrandom(MinRX, MaxRX);

   // set the Y coordinates
   YOne = getrandom(MinRY, MaxRY);
   YTwo = getrandom(MinRY, MaxRY);

   // set the color
   PGL_setfgcolor(PGL_getcolorcode(getrandom(0, MaxColor)));

   // set the pattern
   PGL_setlinetype(Patterns[getrandom(0,TotalPatterns)]);

   // draw the line
   PGL_drawline(XOne, YOne, XTwo, YTwo);

   return (0);
   }

/*
 *****************************************************************************
 */

int RandOpenRect(void)
   //
   // RandOpenRect -- draws open rectangles of random size with random 
   //                 patterned lines and colors.
   //
   {
   // local variables
   int   XOne, XTwo, YOne, YTwo, XHold, YHold;
   PGL_point shape[5];

   // set the color
   PGL_setfgcolor(PGL_getcolorcode(getrandom(0,MaxColor)));

   // set the pattern
   PGL_setlinetype(Patterns[getrandom(0,TotalPatterns)]);

   // set the X coordinates
   XOne = getrandom(MinRX, MaxRX);
   XTwo = getrandom(MinRX, MaxRX);
   if(XOne > XTwo)
      {
      XHold = XOne;
      XOne = XTwo;
      XTwo = XHold;
      }

   // set the Y coordinates
   YOne = getrandom(MinRY, MaxRY);
   YTwo = getrandom(MinRY, MaxRY);
   if(YOne > YTwo)
      {
      YHold = YOne;
      YOne = YTwo;
      YTwo = YHold;
      }

   // set the coordinates for all 5 points
   shape[0].x = XOne;
   shape[0].y = YOne;
   shape[1].x = XTwo;
   shape[1].y = shape[0].y;
   shape[2].x = shape[1].x;
   shape[2].y = YTwo;
   shape[3].x = shape[0].x;
   shape[3].y = shape[2].y;
   shape[4].x = shape[0].x;
   shape[4].y = shape[0].y;

   // draw the rectangle
   PGL_drawpolyline(4,shape);

   return (0);
   }

/*
 *****************************************************************************
 */
int RandSolidRect(void)
   //
   // RandSolidRect -- displays solid rectangles in random sizes and colors
   //                  within the defined random display area.
   //
   {
   // local variables
   int   XOne, XTwo, YOne, YTwo, XHold, YHold;

   // set the color
   PGL_setfgcolor(PGL_getcolorcode(getrandom(0,MaxColor)));

   // set the X coordinates
   XOne = getrandom(MinRX, MaxRX);
   XTwo = getrandom(MinRX, MaxRX);
   if(XOne > XTwo)
      {
      XHold = XOne;
      XOne = XTwo;
      XTwo = XHold;
      }

   // set the Y coordinates
   YOne = getrandom(MinRY, MaxRY);
   YTwo = getrandom(MinRY, MaxRY);
   if(YOne > YTwo)
      {
      YHold = YOne;
      YOne = YTwo;
      YTwo = YHold;
      }

   // draw the rectangle
   PGL_drawrect(XOne, YOne, XTwo - XOne + 1, YTwo - YOne + 1);

   return (0);
   }

/*
 *****************************************************************************
 */

int RandPatternRect(void)
   //
   // RandPatternRect -- displays solid rectangles in random sizes and colors
   //                  within the defined random display area.
   //
   {
   // local variables
   int   XOne, XTwo, XHold, YOne, YTwo, YHold, FColor, BColor;

   // set the foreground color
   FColor = getrandom(0,MaxColor);
   PGL_setfgcolor(PGL_getcolorcode(FColor));

   // set the background color
   while((BColor = getrandom(0,MaxColor)) == FColor);
   PGL_setbgcolor(PGL_getcolorcode(BColor));

   // set the X coordinates
   XOne = getrandom(MinRX, MaxRX);
   XTwo = getrandom(MinRX, MaxRX);
   if(XOne > XTwo)
      {
      XHold = XOne;
      XOne = XTwo;
      XTwo = XHold;
      }

   // set the Y coordinates
   YOne = getrandom(MinRY, MaxRY);
   YTwo = getrandom(MinRY, MaxRY);
   if(YOne > YTwo)
      {
      YHold = YOne;
      YOne = YTwo;
      YTwo = YHold;
      }

   // draw the rectangle
   PGL_drawrect(XOne,YOne,XTwo-XOne+1,YTwo-YOne+1);

   return (0);
   }

/*
 *****************************************************************************
 */

int RandOpenPoly(void)
   //
   // RandOpenPoly -- displays random shaped polygons, in random colors
   //                 drawn with randomly patterned lines.
   //
   {
   // local variables
   int Point, TotalPoints;
   PGL_point shape[12];

   // set the line color
   PGL_setfgcolor(PGL_getcolorcode(getrandom(0,MaxColor)));

   // set the pattern
   PGL_setlinetype(Patterns[getrandom(0,TotalPatterns)]);

   // set the number of points
   TotalPoints = getrandom(PG_MIN,PG_MAX);

   // set all points in polygon
   for(Point=0; Point<TotalPoints; Point++)
      {
      shape[Point].x = getrandom(MinRX, MaxRX);
      shape[Point].y = getrandom(MinRY, MaxRY);
      }

   // point last point back to first point
   shape[TotalPoints].x = shape[0].x;
   shape[TotalPoints].y = shape[0].y;

   // draw the polygon
   PGL_drawpolyline(TotalPoints,shape);

   return (0);
   }

/*
 *****************************************************************************
 */

int RandSolidPoly(void)
   //
   // RandSolidPoly -- displays solid polygons in random sizes and colors
   //                  within the defined random display area.
   //
   {
   // local variables
   int Point, TotalPoints;
   PGL_point shape[12];

   // set the color
   PGL_setfgcolor(PGL_getcolorcode(getrandom(0,MaxColor)));

   // set the number of points
   TotalPoints = getrandom(PG_MIN,PG_MAX);

   // set all points in polygon
   for(Point=0; Point<TotalPoints; Point++)
      {
      shape[Point].x = getrandom(MinRX, MaxRX);
      shape[Point].y = getrandom(MinRY, MaxRY);
      }

   // point last point back to first point
   shape[TotalPoints].x = shape[0].x;
   shape[TotalPoints].y = shape[0].y;

   // draw the polygon
   PGL_drawpolygon(TotalPoints,shape);

   return (0);
   }

/*
 *****************************************************************************
 */

int RandPatternPoly(void)
   //
   // RandPatternPoly -- displays pattern filled polygons in random sizes and 
   //                    colors within the defined random display area.
   //
   {
   // local variables
   int Point, TotalPoints, FColor, BColor;
   PGL_point shape[12];

   // set the foreground color
   PGL_setfgcolor(PGL_getcolorcode(FColor = getrandom(0,MaxColor)));

   // set the background color
   while((BColor = getrandom(0,MaxColor)) == FColor);
   PGL_setbgcolor(PGL_getcolorcode(BColor));

   // set the number of points
   TotalPoints = getrandom(PG_MIN,PG_MAX);

   // set all points in polygon
   for(Point=0; Point<TotalPoints; Point++)
      {
      shape[Point].x = getrandom(MinRX, MaxRX);
      shape[Point].y = getrandom(MinRY, MaxRY);
      }

   // point last point back to first point
   shape[TotalPoints].x = shape[0].x;
   shape[TotalPoints].y = shape[0].y;

   // draw the polygon
   PGL_drawpolygon(TotalPoints,shape);

   return (0);
   }

/*
 *****************************************************************************
 */

int RandScreenBlit(void)
   //
   // RandScreenBlit -- Grabs a portion of the screen and blits it to another
   //                   part of the screen.
   //
   {
   // local variables
   int Height, Width, SrcLeft, SrcTop, DestLeft, DestTop;

   // choose a random width and height
   Width = getrandom(MIN_BLIT_WIDTH,MAX_BLIT_WIDTH);
   Height = getrandom(MIN_BLIT_HEIGHT,MAX_BLIT_HEIGHT);

   // choose a random source area from the left side of screen
   SrcLeft = getrandom(MinRX,XCenter-Width);
   SrcTop = getrandom(MinRY,MaxRY-Height);

   // choose a random dest area from right half of screen (that doesn't overlap source)
   DestLeft = getrandom(XCenter+1,MaxRX-Width-4);
   DestTop = getrandom(MinRY,MaxRY-Height);

   // do the blit
   PGL_screentoscreenblit(SrcLeft, SrcTop, DestLeft, DestTop, Width, Height);

   // return to caller
   return(0);
   }


/*
 *****************************************************************************
 */

int RandBufferBlit(void)
   //
   // RandBufferBlit -- Grabs a portion of the screen and blits it to a ram
   //                   buffer and then to another portion of the screen
   //
   {
   // local variables
   unsigned long bufsize;
   int Height, Width, SrcLeft, SrcTop, DestLeft, DestTop;

   // choose a random width and height
   Width = getrandom(MIN_BLIT_WIDTH,MAX_BLIT_WIDTH);
   Height = getrandom(MIN_BLIT_HEIGHT,MAX_BLIT_HEIGHT);

   // choose a random source area from the left side of screen
   SrcLeft = getrandom(MinRX,XCenter-Width);
   SrcTop = getrandom(MinRY,MaxRY-Height);

   // choose a random dest area from right half of screen (that doesn't overlap source)
   DestLeft = getrandom(XCenter+1,MaxRX-Width-4);
   DestTop = getrandom(MinRY,MaxRY-Height);

   // dynamically allocate necessary CPU memory for operation in dwords
   bufsize = PGL_getbuffersize(Width, Height) * 4;
   BlitBufPtr = (unsigned long huge *) halloc (bufsize, 1);
   if(BlitBufPtr == NULL)
   {
      // return to caller
      return (1);
   }

   // do the blit to the buffer
   PGL_screentobufferblit(BlitBufPtr, SrcLeft, SrcTop, Width, Height);

   // do the blit to the screen
   PGL_buffertoscreenblit(BlitBufPtr, DestLeft, DestTop, Width, Height);

   // free allocated CPU memory
   hfree(BlitBufPtr);

   // return to caller
   return(0);
}

/*
 *****************************************************************************
 */



/*---------------------------------------------------------------------------
    Setup palette for 4 bit 121 format
---------------------------------------------------------------------------*/
void setpal4(void)
{
    int i, r, g, b;
    int gcol[]  = {0, 21, 42, 63};
    int rbcol[] = {0, 63};
    PGL_palette entry;

    i = 0;
    for (r = 0; r <= 1; r++)
    {
        for (g = 0; g < 4; g++)
        {
            for (b = 0; b <= 1; b++)
            {
                entry.red = *(rbcol + r);
                entry.green = *(gcol + g);
                entry.blue = *(rbcol + b);
                PGL_setpalette(i, entry);
                i++;
            }
        }
    }
}

/*
 *****************************************************************************
 */

/*---------------------------------------------------------------------------
    Setup palette for 8 bit 332 format
---------------------------------------------------------------------------*/
void setpal8(void)
{
    int i, r, g, b;
    int bcol[]  = {0, 44, 55, 63};
    int rgcol[] = {0, 33, 41, 48, 52, 56, 60, 63};
    PGL_palette entry;

    i = 0;
    for (r = 0; r < 8; r++)
    {
        for (g = 0; g < 8; g++)
        {
            for (b = 0; b < 4; b++)
            {
                entry.red = *(rgcol + r);
                entry.green = *(rgcol + g);
                entry.blue = *(bcol + b);
                PGL_setpalette(i, entry);
                i++;
            }
        }
    }
}

/*
 *****************************************************************************
 */

/*---------------------------------------------------------------------------
    VIEW_TARGA - view a targa file

    Inputs      : filename

    Return codes: 0 - success
                  1 - can't open given file
                  2 - targa file is not supported
                  3 - not enough memory to allocate input buffer

    Notes       : a valid set accelerator mode is assumed
---------------------------------------------------------------------------*/

/* Targa file structures - must be byte aligned */
#pragma pack(1)

typedef struct
{
    char id_length;
    char cm_type;      // 0 = no color map, 1 = color map
    char image_type;   // 2 = uncompressed
    int  cm_origin;
    int  cm_length;
    char cm_entrysize;
    int  x_origin;
    int  y_origin;
    int  width;        // image width in pixels
    int  height;       // image height in pixels
    char pixel_depth;  // image bits per pixel (8, 16, 24)
    char image_coord;  // image start coordinates
                                //  0 - bottom left
                                //  1 - bottom right
                                //  2 - top left
                                //  3 - top right
} Targa_Header;

#pragma pack()


unsigned long convtargadata(unsigned long r, unsigned long b, unsigned long g)
{
    unsigned long data;

    // convert to appropriate size
    switch(modeinfo.bpp)
    {
        case 4:
            // 4 bit  - 121 mode
            data = ((r & 0x80) >> 4) | ((g & 0xc0) >> 5) | ((b & 0x80) >> 7);
            break;

        case 8:
            // 8 bit  - 332 mode
            data = (r & 0xe0) | ((g >> 3) & 0x1c) | ((b >> 6) & 0x03);
            break;

        case 16:
            // 16 bit
            switch(modeinfo.depth)
            {
                case 555:
                    b = b & 0xf8;
                    g = g & 0xf8;
                    r = r & 0xf8;
                    data = (r << 7) | (g << 2) | (b >> 3);
                    break;

                case 565:
                    b = b & 0xf8;
                    g = g & 0xfc;
                    r = r & 0xf8;
                    data = (r << 8) | (g << 3) | (b >> 3);
                    break;
            }
            break;

        case 24:
            // 24 bit
            switch(modeinfo.depth)
            {
                case DEPTH_24_RGB:
                    data = (r << 16) | (g << 8) | b;
                    break;

                case DEPTH_24_BGR:
                    data = (b << 16) | (g << 8) | r;
                    break;
            }
            break;

        case 32:
            // 32 bit
            switch(modeinfo.depth)
            {
                case DEPTH_32_RGBA:
                    data = (r << 24) | (g << 16) | (b << 8);
                    break;

                case DEPTH_32_ARGB:
                    data = (r << 16) | (g << 8) | b;
                    break;

                case DEPTH_32_BGRA:
                    data = (r << 8) | (g << 16) | (b << 24);
                    break;

                case DEPTH_32_ABGR:
                    data = r | (g << 8) | (b << 16);
                    break;
            }
            break;
    }

    return (data);
}

unsigned long reverse4bpp(unsigned long data)
{
    unsigned long nib1, nib2, nib3, nib4;
    unsigned long nib5, nib6, nib7, nib8;

    nib1 = (data & 0x0f) << 4;
    nib2 = (data & 0xf0) >> 4;
    nib3 = (data & 0xf00) << 4;
    nib4 = (data & 0xf000) >> 4;
    nib5 = (data & 0xf0000) << 4;
    nib6 = (data & 0xf00000) >> 4;
    nib7 = (data & 0xf000000) << 4;
    nib8 = (data & 0xf0000000) >> 4;

    return (nib8 | nib7 | nib6 | nib5 | nib4 | nib3 | nib2 | nib1);
}

int View_Targa(void)
{
   FILE *TargaFile;
   Targa_Header header;
   unsigned char *inbuffer;
   int drawx, drawy;
   int RealXStart, RealYStart;
   int i, j, x, y;
   unsigned long temp1, temp2, temp3, temp4;
   unsigned long data;
   unsigned char r, g, b, e;
   int hostwrts, shifter;
   int chkwrts;
   unsigned long rotation;

   // open targa file
   TargaFile = fopen("test.tga", "rb");
   if (TargaFile == NULL)
   {
       if (TargaFile != NULL) fclose(TargaFile);
       return (1);
   }

   // check for support ability (type 2, no color map)
   fread(&header, sizeof(Targa_Header), 1, TargaFile);
   if ((header.cm_type != 0) ||
       (header.image_type != 2) ||
       (header.pixel_depth != 24) ||
       (header.image_coord == 1) ||
       (header.image_coord == 3))
        {
           if (TargaFile != NULL) fclose(TargaFile);
           return (2);
        }

   // open input buffer (image width * image pixel depth in bytes)
   inbuffer = (unsigned char *) malloc ((header.width + 1) * 3);
   if (inbuffer == NULL)
   {
       printf("Not enough memory to show targa file.\n");
       if (TargaFile != NULL) fclose(TargaFile);
       exit(1);
   }

   // setup palette for 4/8 bit mode
   if (modeinfo.bpp < 16)
   {
      // set the new palette values
      if (modeinfo.bpp == 4)
      {
         setpal4();
      }
      else
      {
         setpal8();
      }
   }

   // determine drawing rectangle
   if (header.width < modeinfo.xres)
       drawx = header.width;
   else
       drawx = modeinfo.xres;

   if (header.height < modeinfo.yres)
       drawy = header.height;
   else
       drawy = modeinfo.yres;

   // calculate real coordinates of image in display area
   RealXStart = (modeinfo.xres - drawx)/2;
   RealYStart = (modeinfo.yres - drawy)/2;

   // adjust X coordinates for 24 bpp
   if (modeinfo.bpp == 24)
   {
      hostwrts = 32 / 8;
      drawx = drawx * 3;
      RealXStart = RealXStart * 3;
      rotation = (unsigned long)((RealXStart / 4) % 6);
   }
   else
   {
      hostwrts = 32 / modeinfo.bpp;
      rotation = 0;
   }


   // setup engine for buffer to screen host data transfer
   PGL_waitforemptyfifo();
   PGL_waitforidle();
   temp1 = regr(DP_SRC);
   temp2 = regr(DP_MIX);
   temp3 = regr(SRC_CNTL);
   temp4 = regr(DST_CNTL);

   regw(DP_SRC, FRGD_SRC_HOST);
   regw(DP_MIX, FRGD_MIX_S | BKGD_MIX_S);
   regw(SRC_CNTL, 0);

   if (header.image_coord == 0)
   {
       // bottom left
       regw(DST_CNTL, (temp4 & DST_24_ROTATION_ENABLE) | (rotation << 8) |
                      DST_Y_BOTTOM_TO_TOP | DST_X_LEFT_TO_RIGHT);
       regw(DST_X, (unsigned long)RealXStart);
       regw(DST_Y, (unsigned long)(RealYStart + drawy - 1));
       regw(DST_HEIGHT, (unsigned long)drawy);
       regw(DST_WIDTH, (unsigned long)drawx);
   }
   else
   {
       // top left
       regw(DST_CNTL, (temp4 & DST_24_ROTATION_ENABLE) | (rotation << 8) |
                      DST_Y_TOP_TO_BOTTOM | DST_X_LEFT_TO_RIGHT);
       regw(DST_X, (unsigned long)RealXStart);
       regw(DST_Y, (unsigned long)RealYStart);
       regw(DST_HEIGHT, (unsigned long)drawy);
       regw(DST_WIDTH, (unsigned long)drawx);
   }

    PGL_waitforemptyfifo();

    chkwrts = 0;
    for (y = 0; y < drawy; y++)
    {
        // get next image scanline
        fread((unsigned char *)inbuffer, header.width * 3, 1, TargaFile);

        // get next line of pixels from input buffer
        i = 0;
        for (x = 0; x < (drawx / hostwrts); x++)
        {
            // hostwrites is fixed at 4 for 24 bpp modes
            if (modeinfo.bpp == 24)
            {
                b = (unsigned char)(*(inbuffer + i) & 0xff);
                g = (unsigned char)(*(inbuffer + i + 1) & 0xff);
                r = (unsigned char)(*(inbuffer + i + 2) & 0xff);
                e = (unsigned char)(*(inbuffer + i + 3) & 0xff);
                data = ((unsigned long)e << 24) |
                       ((unsigned long)r << 16) |
                       ((unsigned long)g << 8) |
                       (unsigned long)b;
                i = i + 4;
            }
            else
            {
                // pack data according to bpp
                shifter = 0;
                data = 0;
                for (j = 0; j < hostwrts; j++)
                {
                    // get 24 bit component data
                    b = (unsigned char)(*(inbuffer + i) & 0xff);
                    g = (unsigned char)(*(inbuffer + i + 1) & 0xff);
                    r = (unsigned char)(*(inbuffer + i + 2) & 0xff);
                    i = i + 3;
                    data = data | (convtargadata((unsigned long)r, (unsigned long)b, (unsigned long)g) << shifter);
                    shifter = shifter + modeinfo.bpp;
                }
            }

            // load buffer contents to video memory
            if (chkwrts > 15)
            {
                PGL_waitforemptyfifo();
                chkwrts = 0;
            }
            if (modeinfo.bpp == 4)
            {
                data = reverse4bpp(data);
            }
            regw(HOST_DATA0, data);
            chkwrts++;
        }
    }

   // restore main engine context
   PGL_waitforemptyfifo();
   PGL_waitforidle();

   regw(DP_SRC, temp1);
   regw(DP_MIX, temp2);
   regw(SRC_CNTL, temp3);
   regw(DST_CNTL, temp4);


   // close buffers and targa file
   free(inbuffer);
   if (TargaFile != NULL) fclose(TargaFile);

   // return to caller
   return (0);
}


/*
 *****************************************************************************
 */

int DoDemo(int (*DemoFunc)(void), int (*InitFunc)(void), 
           int (*DeInitFunc)(void), int (*ClearFunc)(int),
           long DemoCount, int BackColour)
   //
   // DoDemo -- calls the caller specified demo function, the requested number
   //           of times, checking for user input to cancel the demo. DoDemo 
   //           returns 0 if demo was not interrupted by the user, and 
   //           non-zero if user pressed a key to terminate demo.
   //
   // DemoFunc - points to the demo function to run.
   //
   // InitFunc - points to initialization function for demo
   //
   // DeInitFunc - points to de-initialization function for demo
   //
   // DemoCount - defines the number of random lines that are drawn before the
   //             routine quits. If DemoCount is 0 that means go until user 
   //             presses a key. If DemoCount is -1 that means run demo once
   //             and wait until the user presses a key.
   //
{
   long     Count = 0;           // counts the number of times demo is run
   unsigned Interrupted = 0;     // flag for user interruption
   int KeyIn = 0;                // used to record whether user pressed a key
   int ascii_code, scan_code;    // used to which key was pressed
   char AnyKey[] = "Press any key to exit.";

   // call init function if there is one
   if(InitFunc != NULL)
      InitFunc();

   if(DemoCount == STATIC_DEMO)
   {
      // in static demo mode, run demo once and wait for a key

      // run the demo
      DemoFunc();

      // set the text color
      PGL_setfgcolor(PGL_getcolorcode(YELLOW));

      // display the press any key to quit message
      PGL_text((modeinfo.xres - (strlen(AnyKey)*8))/2, modeinfo.yres-15, 
               AnyKey, normalfont);

      // wait for a key
      getch();
   }
   else
   {
      // in random demo mode, so
      // run the demo the requested number of times or until key is pressed

      RandMessage();
      while(KeyIn == 0)
      {
         // check if key was pressed
         if (kbhit() != 0)
         {
            // read which key was pressed
            get_key_code(&ascii_code, &scan_code);

            // check keys
            if (ascii_code == ' ')
            {
               // clear screen if key press was the SPACE bar
               ClearFunc(BackColour);
            }
            else if ((ascii_code == 'p') || (ascii_code == 'P'))
            {
               // pause if P key was pressed
               getch();
            }
            else
            {
               // leave with any other key
               KeyIn = 1;
            }
         }

         // run one interation of the requested demo
         DemoFunc();

         // check if all requested demos have been run
         ++Count;

         if (KeyIn != 0)
         {
            // user interrupted demo
            Interrupted = 1;
         }

         if ((DemoCount != 0) && (Count == DemoCount))
         {
            KeyIn = 1;
         }
      }
   }

   // call de-init function if there is one
   if(DeInitFunc != NULL)
      DeInitFunc();   

   // let caller know if demo was interrupted
   return(Interrupted);
}

/*
 *****************************************************************************
 */

