/******************************************************************************
 * Header file to mach64 Chapter 4 sample code                                *
 * Includes structures, prototypes, and globals.                              *
 *                                                                            *
 * Copyright (c) 1994-1998 ATI Technologies Inc.  All rights reserved.        *
 ******************************************************************************/

#ifndef _MAIN_H
#define _MAIN_H

// Structures.

typedef struct                          // See mach64 BIOS extension info.
{
    unsigned short size;
    unsigned char revision;
    unsigned char mode_tables;
    unsigned short mode_table_offset;
    unsigned char mode_table_size;
    unsigned char vga_type;             // See VGA types.
    unsigned short asic_id;
    unsigned char vga_boundary;
    unsigned char memory_size;
    unsigned char dac_type;             // See DAC types.
    unsigned char memory_type;
    unsigned char bus_type;             // See BUS types.
    unsigned char monitor_cntl;
    unsigned short aperture_addr;
    unsigned char aperture_cfg;
    unsigned char colour_depth_support;
    unsigned char ramdac_feature_support;
    unsigned char io_type;
    unsigned short reserved1;
    unsigned short io_base;
    unsigned char reserved2[6];
} query_structure;

typedef struct
{
    unsigned int io_base;
    unsigned int io_type;               // Fixed or Relocatable.
} io_query;

typedef struct
{
    int xres;
    int yres;
    int bpp;
    int depth;                          // Colour depth support.
    int pitch;
    int linear_aperture_size;           // 4MB or 8MB.
    long linear_address;                // Physical linear aperture address.
    long virt_seg;                      // Virtual linear aperture address.
} modecfg;


typedef struct
{
    int x;
    int y;
} point;


typedef struct
{
    int length;
    point *point_ptr;
} polygon;


// Prototypes.

// Functions in init.c

int init_graphics (void);
int get_old_mode (void);
int set_old_mode (void);
void process_command_line (int argc, char *argv[]);

// Functions in m64bios.c

long phys_to_virt (long physical, long size);
int load_and_set_mode (int xres, int bpp, int pitch);
int enable_aperture (void);
int short_query_function (void);
int long_query (void);
int short_query (void);

// Functions in colour.c

unsigned long get_colour_code (int colour_index);

// Functions in draw.c

int clear_screen (void);
int draw_point (int x, int y, int colour);
int draw_frect (int x0, int y0, int x1, int y1, int colour);
int draw_line (int x0, int y0, int x1, int y1, int colour);
int draw_rect (int x0, int y0, int x1, int y1, int colour);
int draw_polygon (polygon *pgon, int xoff, int yoff, int colour);


// Globals.

extern modecfg MODE_INFO;
extern query_structure QUERY_DATA;
extern io_query IO_DATA;
extern int OLD_MODE;
extern int GMODE_RES;
extern int GCLR_DEPTH;

#endif // _MAIN_H
