/*******************************************************************************
 *	ATI 3D RAGE SDK sample code												   *	
 *																			   *
 *  Knight Demo																   *
 *																			   *
 *  Copyright (c) 1996-1997 ATI Technologies, Inc.  All rights reserved.	   *	
 *																			   *
 *	The base sequence and set up for the Knight Demo castle. Includes		   *	
 *	initialization,	drawing, shading and clean-up for modeling of castle.	   *
 *******************************************************************************/
#ifndef CASTLE_H
#define CASTLE_H
// -----------------------------------------------------------------------------

class Castle {
public:
	static void Cleanup(void) throw(Exception);
	static void Initialize(void) throw(Exception);

	static void Draw(Clipper& rClipper) throw(Exception);
	static void DrawShadow(Clipper& rClipper) throw(Exception);

	static const Vector&	Position(void) { return m_position; }
	static const Matrix&	Rotation(void) { return m_rotation; }

protected:
	static void PrecastShadow(void);

private:
	static Vector	m_position;
	static Matrix	m_rotation;

	static Object*			m_pCastle;
	static Object*			m_pSideL;
	static Object*			m_pSideR;
	static Ati3dTexture*	m_pTexture;

	static int			m_shadowVertexCount;
	static int			m_shadowFaceCount;
	static Vertex		m_shadowVertices[];
	static TLVertex		m_shadowTLVertices[];
	static struct _FaceIndex {
		int v0, v1, v2;
	}				m_shadowFacelist[];

	static void PrecastCallback(const Vector& a, const Vector& b, const Vector& c);
	static int  AddShadowVertex(const Vector& v);
	static void AddShadowFace(int a, int b, int c);
	static void AddShadowFace(const Vector& a, const Vector& b, const Vector& c);
	static void AddShadowTransQuad(const Vector& a, const Vector& b, const Vector& c, const Vector& d, const Matrix& rot, const Vector& trans);
	static void AddShadowTransTri(const Vector& a, const Vector& b, const Vector& c, const Matrix& rot, const Vector& trans);
	static void AddShadowQuad(const Vector& a, const Vector& b, const Vector& c, const Vector& d);
};

// -----------------------------------------------------------------------------
#endif
